package edu.unl.consystlab.sudokuSolver.consistencyAlgorithms;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import edu.unl.consystlab.sudokuSolver.constraintProblem;
import edu.unl.consystlab.sudokuSolver.problemVariable;
import edu.unl.consystlab.sudokuSolver.sudokuBoard;
import edu.unl.consystlab.sudokuSolver.variableIndexAndValueGrouping;

public class backCheckAll extends consistencyAlgorithm {

	public backCheckAll(constraintProblem newProblem, sudokuBoard board) {
		super(newProblem, board);
	}

	
	public boolean runAlgorithm() throws InterruptedException
	{
		variableReductions = new LinkedList();

		Iterator i = ((Collection)parentProblem.getAllVariables()).iterator();
		while(i.hasNext())
		{
			problemVariable currentVariable = (problemVariable)i.next();

			consistencyAlgorithm myBackCheckOnVariable = new backCheckOnVariable(parentProblem, ourBoard, currentVariable);
			if(!myBackCheckOnVariable.runAlgorithm())
			{
				//if there was an error set this to have an error and get the constraint that caused it.
				this.setEncounteredError(true);
				this.setBrokenConstraint(myBackCheckOnVariable.getBrokenConstraint());
				return false;
			}
		}
		
		this.setBrokenConstraint(null);
		this.setEncounteredError(false);
		return true;
	}
}
